import { StateNode } from "@tldraw/editor";
import { Idle } from "./childStates/Idle.mjs";
import { Lasering } from "./childStates/Lasering.mjs";
class LaserTool extends StateNode {
  static id = "laser";
  static initial = "idle";
  static children = () => [Idle, Lasering];
  static isLockable = false;
  onEnter = () => {
    this.editor.setCursor({ type: "cross", rotation: 0 });
  };
}
export {
  LaserTool
};
//# sourceMappingURL=LaserTool.mjs.map
